#include "copyright.i"

!*******************************************************************************!
! Module: nextinpcrd_section_mod
!
! Description: <TBS>
!
!*******************************************************************************
module nextinpcrd_section_mod

! MXNXFL is maximum number of %FLAG cards that can be specified

  integer, parameter    :: mxnxfl = 500

! Hide internal routines:

  private       nnbchr

contains

!*******************************************************************************!
! Subroutine:  nxtsec_crd
!
! Description:  This code is a rehack of the equivalent code for prmtop's.  Here
!               the target is an new-style inpcrd file.  I think Tom Darden did
!               the rehack, but just copied the comments from the previous
!               prmtop-oriented subroutine.  I have thus not propagated the
!               comments; look at the nxtsec() code for enlightenment.
!
!*******************************************************************************

subroutine nxtsec_crd(iunit, iout, ionerr, fmtold, flag, fmt, iok)

  implicit none

  integer  IUNIT
  integer  IOUT
  integer  IONERR
  character*(*) FMTOLD,FMT,FLAG
  integer  IOK

  logical  FIRST
  DATA FIRST/.TRUE./
  common /nxtlc4_crd/first

  CHARACTER*80 NXTFLG
  CHARACTER*8 PRDAT,PRTIM
  CHARACTER*255 AA
  integer  IBLOCK
  integer  INXTFL
  integer  IPRVRR
  integer  NUMFLG
  real     RPVER
  COMMON /NXTLC1_crd/INXTFL(2,MXNXFL),IPRVRR,NUMFLG,IBLOCK
  COMMON /NXTLC2_crd/RPVER
  COMMON /NXTLC3_crd/NXTFLG(MXNXFL),PRDAT,PRTIM

  integer  I
  integer  IPT
  integer  IPT2
  integer  IPT3
  integer  IPT4
  integer  IPT5
  integer  IPT6
  integer  IPT7
  integer  IPT8
  integer  IPT9
  integer  IPT10
  integer  LFLAG
  integer  IL2US
  integer  IFIND
  integer  MBLOCK
  integer  ILFO

      IOK = 0
      IF (FIRST) THEN

      REWIND(IUNIT)

!   First, see if this is a new format INPCRD file. That is, if the %VERSION
!   line exists. If not, then we assume it's an old format INPCRD file. In
!   this case, every call to NXTSEC will simply result in an immediate
!   return. This means all reads from the calling routine will be done
!   sequentially from the INPCRD file. Store the version number as a real
!   in RPVER. Store the date and time strings as character strings in
!   PRDAT and PRTIM.

      do
         READ(IUNIT,11,END=20) AA
   11    FORMAT(A)
         IF (AA(1:8).NE.'%VERSION') cycle

         IPT = INDEX(AA,'VERSION_STAMP')
         IF (IPT.LE.0) cycle

         IPT2 = NNBCHR(AA,IPT+13,0,0)
         IF (AA(IPT2:IPT2).NE.'=') GO TO 9000

         IPT3 = NNBCHR(AA,IPT2+1,0,0)
         IF (AA(IPT3:IPT3).NE.'V') GO TO 9001

         IPT4 = NNBCHR(AA,IPT3+1,0,1)
         IF (IPT4-1 - (IPT3+1) + 1 .NE.8) GO TO 9002
         READ(AA(IPT3+1:IPT4-1),'(F8.3)') RPVER

         IPT5 = INDEX(AA,'DATE')
         IF (IPT5.LE.0) THEN
           PRDAT = 'xx/xx/xx'
           PRTIM = 'xx:xx:xx'
           GO TO 50
         END IF
         IPT6 = NNBCHR(AA,IPT5+4,0,0)
         IF (AA(IPT6:IPT6).NE.'=') GO TO 9003
         IPT7 = NNBCHR(AA,IPT6+1,0,0)
         IPT8 = NNBCHR(AA,IPT7+1,0,1)
         IF (IPT8-1 - IPT7 + 1 .NE. 8) GO TO 9004
         PRDAT = AA(IPT7:IPT8-1)

         IPT9 = NNBCHR(AA,IPT8+1,0,0)
         IPT10 = NNBCHR(AA,IPT9+1,0,1)
         IF (IPT10-1 - IPT9 + 1 .NE. 8) GO TO 9005
         PRTIM = AA(IPT9:IPT10-1)
         WRITE(IOUT,15) RPVER,PRDAT,PRTIM
   15    FORMAT('| New format inpcrd file being parsed.',/, &
                '| Version = ',F8.3,' Date = ',A,' Time = ',A)
         IPRVRR = 0
         GO TO 50
      end do

!   Get here if no VERSION flag read. Set IPRVRR = 1 and return.
!   On subsequent calls, if IPRVRR = 1, we return immediately.

   20 IPRVRR = 1
      IOK = -1
      WRITE(IOUT,21)
   21 FORMAT('|  INFO: Old style inpcrd file read',/)
      fmt = fmtold
      rewind(iunit)
      first = .false.
      RETURN

!   %VERSION line successfully read. Now load the flags into NXTFLG(I)
!   and the line pointer and lengths of the flags into 
!   INXTFL(1,I) and INXTFL(2,I), respectively. NUMFLG will be the 
!   total number of flags read.

   50 REWIND(IUNIT)
      NUMFLG = 0
      I = 1
      do
         READ(IUNIT,11,END=99) AA
         IF (AA(1:5).EQ.'%FLAG') THEN
           NUMFLG = NUMFLG + 1
           IPT2 = NNBCHR(AA,6,0,0)
           IF (IPT2.EQ.-1) GO TO 9006
           IPT3 = NNBCHR(AA,IPT2,0,1)-1

           INXTFL(1,NUMFLG) = I
           INXTFL(2,NUMFLG) = IPT3-IPT2+1
           NXTFLG(NUMFLG) = AA(IPT2:IPT3)
         END IF
         I = I + 1
      end do
   99 REWIND(IUNIT)
      IBLOCK = 0
      FIRST = .FALSE.
      END IF

!   Start search for passed flag name.
!   If this is an old-style INPCRD file, we can't do the search. Simply
!   set IOK = -1, FMT to FMTOLD, and return

      IF (IPRVRR.EQ.1) THEN
         IOK = -1
         FMT = FMTOLD
         RETURN
      END IF

      LFLAG = NNBCHR(FLAG,1,0,1)-1
      IF (LFLAG.EQ.-2) LFLAG = LEN(FLAG)
      DO I = 1,NUMFLG
         IF (LFLAG.EQ.INXTFL(2,I)) THEN
            IF (FLAG(1:LFLAG).EQ.NXTFLG(I)(1:LFLAG)) THEN
               IL2US = INXTFL(1,I)
               GO TO 120
            END IF
         END IF
      END DO

!   Get here if flag does not correspond to any stored. Either stop
!   or return depending on IONERR flag.

      IF (IONERR.EQ.0) THEN
         GO TO 9007
      ELSE IF (IONERR.EQ.1) THEN
         IOK = -2
         RETURN
      END IF

!   Flag found. Set file pointer to the first line following the appropriate
!   %FLAG line and then search for %FORMAT field.
!   IBLOCK keeps track of the last %FLAG found. If this preceeded the
!   one being read now, we read forward to find the current requested FLAG.
!   If this followed the current request, rewind and read forward the
!   necessary number of lines. This should speed things up a bit.

  120 IFIND = I
      MBLOCK = IBLOCK
      IF (IFIND.GT.IBLOCK) THEN
         do
            READ(IUNIT,11,END=9008) AA
            IF (AA(1:5).EQ.'%FLAG') THEN
               MBLOCK = MBLOCK + 1
               IF (MBLOCK.EQ.IFIND) exit
            END IF
         end do
      ELSE
         REWIND(IUNIT)
         DO I = 1,IL2US
            READ(IUNIT,11,END=9008)
         END DO
      END IF

      DO
         READ(IUNIT,11,END=9009) AA
         IF (AA(1:7).EQ.'%FORMAT') exit
      END DO

!   First %FORMAT found following appropriate %FLAG. Extract the
!   format and return. All non-blank characters following %FORMAT
!   comprise the format string (embedded blanks allowed).

      IPT2 = NNBCHR(AA,8,0,0)
      IF (IPT2.EQ.-1) GO TO 9010
      DO I = LEN(AA),IPT2,-1
         IF (AA(I:I).NE.' ') exit
      END DO
      IPT3 = I

!   Format string is in IPT2:IPT3. Make sure passed FMT string is large
!   enought to hold this and then return.

      ILFO = IPT3-IPT2+1
      IF (ILFO.GT.LEN(FMT)) GO TO 9011
      FMT = ' '
      FMT(1:ILFO) = AA(IPT2:IPT3)

!   Update IBLOCK pointer and return

      IBLOCK = IFIND
      RETURN

!   Errors:

 9000 WRITE(IOUT,9500)
 9500 FORMAT('ERROR: No = sign after VERSION_STAMP field in INPCRD')
      STOP
 9001 WRITE(IOUT,9501)
 9501 FORMAT('ERROR: Version number in INPCRD does not start with V')
      STOP
 9002 WRITE(IOUT,9502)
 9502 FORMAT('ERROR: Mal-formed version number in INPCRD. ', &
             'Should be 8 chars')    
      STOP
 9003 WRITE(IOUT,9503)
 9503 FORMAT('ERROR: No = sign after DATE field in INPCRD')
      STOP
 9004 WRITE(IOUT,9504)
 9504 FORMAT('ERROR: Mal-formed date string in INPCRD. ', &
             'Should be 8 characters & no embedded spaces.')
      STOP
 9005 WRITE(IOUT,9505)
 9505 FORMAT('ERROR: Mal-formed time string in INPCRD. ', &
             'Should be 8 characters & no embedded spaces.')
      STOP
 9006 WRITE(IOUT,9506)
 9506 FORMAT('ERROR: No flag found following a %FLAG line in INPCRD')
      STOP
 9007 WRITE(IOUT,9507) FLAG(1:LFLAG)
 9507 FORMAT('ERROR: Flag "',A,'" not found in INPCRD file')
      STOP
 9008 WRITE(IOUT,9508) FLAG(1:LFLAG)
 9508 FORMAT('ERROR: Programming error in routine NXTSEC at "',A,'"')
      STOP
 9009 WRITE(IOUT,9509) FLAG(1:LFLAG)
 9509 FORMAT('ERROR: No %FORMAT field found following flag "',A,'"')
      STOP
 9010 WRITE(IOUT,9510) FLAG(1:LFLAG)
 9510 FORMAT('ERROR: No format string found following a %FORMAT ', &
             'line in INPCRD', /, 'Corresponding %FLAG is "',A,'"')
      STOP
 9011 WRITE(IOUT,9511) FLAG(1:LFLAG)
 9511 FORMAT('ERROR: Format string for flag "',A,'" too large',/, &
             '       for FMT call-list parameter')
      STOP

end subroutine nxtsec_crd

!*******************************************************************************
!
! Subroutine:  nxtsec_crd_reset
!
! Description: <TBS>
!
!*******************************************************************************

subroutine nxtsec_crd_reset()

  implicit none

  integer  inxtfl
  integer  iprvrr
  integer  numflg
  integer  iblock
  common /nxtlc1_crd/inxtfl(2,mxnxfl),iprvrr,numflg,iblock
      
  iblock = 0

  return

end subroutine nxtsec_crd_reset

!*******************************************************************************
!
! Function:  nnbchr
!
! Description:
!
!   IOPER = 0: Find next non-blank character
!   IOPER = 1: Find next blank character
!
!   On return, NNBCHR is set to the appropriate pointer, or to -1
!      if no non-blank character found (IOPER = 0) or no blank
!      character found (IOPER = 1).
!*******************************************************************************

function nnbchr(aa, ibeg, iend, ioper)

  implicit none

  integer  nnbchr
  character*(*) aa
  integer  ibeg
  integer  iend
  integer  ioper

  integer  i
  integer  ibg
  integer  ien

  ibg = ibeg
  ien = iend
  if (ibeg.le.0) ibg = 1
  if (iend.le.0) ien = len(aa)

  if (ioper.eq.0) then
    do i = ibg,ien
      if (aa(i:i).ne.' ') then
        nnbchr = i
        return
      end if
    end do
    nnbchr = -1
  else if (ioper.eq.1) then
    do i = ibg,ien
      if (aa(i:i).eq.' ') then
        nnbchr = i
        return
      end if
    end do
    nnbchr = -1
  end if

  RETURN

end function nnbchr

end module nextinpcrd_section_mod
