#include "copyright.i"

!*******************************************************************************!
! Module: mdin_amoeba_dat_mod
!
! Description: <TBS>
!
!*******************************************************************************

module mdin_amoeba_dat_mod
#ifdef AMOEBA

  implicit none

! Data that should be broadcast to slave processes from the master:

  integer, parameter    :: mdin_amoeba_int_cnt = 23

  integer                    do_amoeba_valence, do_amoeba_nonbond, do_bond, &
                             do_ureyb, do_reg_angle, do_trig_angle, do_opbend, &
                             do_torsion, do_pi_torsion, do_strbend, &
                             do_torsion_torsion, do_str_torsion, do_recip, &
                             do_adjust, do_direct, do_self, do_vdw, &
                             do_induced, do_vdw_taper, do_vdw_longrange, &
                             beeman_integrator, dipole_scf_iter_max, &
                             amoeba_verbose

  common / mdin_amoeba_int / do_amoeba_valence, do_amoeba_nonbond, do_bond, &
                             do_ureyb, do_reg_angle, do_trig_angle, do_opbend, &
                             do_torsion, do_pi_torsion, do_strbend, &
                             do_torsion_torsion, do_str_torsion, do_recip, &
                             do_adjust, do_direct, do_self, do_vdw, &
                             do_induced, do_vdw_taper, do_vdw_longrange, &
                             beeman_integrator, dipole_scf_iter_max, &
                             amoeba_verbose


  save  :: / mdin_amoeba_int /

  integer, parameter    :: mdin_amoeba_dbl_cnt = 7

  double precision              compress, dipole_scf_tol, ee_dsum_cut, &
                                ee_damped_cut, sor_coefficient, &
                                thole_expon_coeff, vdw_taper

  common / mdin_amoeba_dbl /    compress, dipole_scf_tol, ee_dsum_cut, &
                                ee_damped_cut, sor_coefficient, &
                                thole_expon_coeff, vdw_taper

  save  :: / mdin_amoeba_dbl /

contains

!*******************************************************************************!
! Subroutine:  init_mdin_amoeba_dat
!
! Description: <TBS>
!
!*******************************************************************************

subroutine init_mdin_amoeba_dat

  use file_io_dat_mod
  use file_io_mod

  implicit none

! Local variables:

  integer       :: ifind

  namelist /amoeba/ do_amoeba_valence, do_amoeba_nonbond, &
                    do_bond, do_ureyb, do_reg_angle,  &
                    do_trig_angle, do_opbend, do_torsion, do_str_torsion, &
                    do_pi_torsion, do_strbend, do_torsion_torsion, &
                    do_recip, do_adjust, do_direct, do_self, &
                    do_vdw, do_induced, amoeba_verbose, beeman_integrator, & 
                    sor_coefficient, dipole_scf_tol, &
                    dipole_scf_iter_max, ee_dsum_cut, ee_damped_cut, &
                    thole_expon_coeff, vdw_taper, do_vdw_taper, &
                    do_vdw_longrange, compress

  ! Set default values.

  do_amoeba_valence = 1
  do_amoeba_nonbond = 1
  do_bond = 1
  do_ureyb = 1
  do_reg_angle = 1
  do_trig_angle = 1
  do_opbend = 1
  do_torsion = 1
  do_pi_torsion = 1
  do_strbend = 1
  do_torsion_torsion = 1
  do_str_torsion = 1
  do_recip = 1
  do_adjust = 1
  do_direct = 1
  do_self = 1
  do_vdw = 1
  do_induced = 1

  do_vdw_taper = 1
  do_vdw_longrange = 1
  beeman_integrator = 0
  dipole_scf_iter_max = 50
  amoeba_verbose = 0
  compress = 0.000046d0
  dipole_scf_tol = 0.01d0
  ee_dsum_cut = 7.d0
  ee_damped_cut = 4.5d0
  sor_coefficient = 0.75d0
  thole_expon_coeff = 0.39d0
  vdw_taper = 0.9d0

  rewind(mdin)
  call nmlsrc('amoeba', mdin, ifind)
  if (ifind .ne. 0) read(mdin, nml = amoeba)

  call am_val_set_user_bit(do_bond, do_ureyb, do_reg_angle, do_trig_angle, &
                           do_opbend, do_torsion, do_str_torsion, &
                           do_pi_torsion, do_strbend, &
                           do_torsion_torsion)

  call am_nonbond_set_user_bit(do_recip, do_adjust, do_direct, do_self, &
                               do_vdw, do_induced)

  return
  
end subroutine init_mdin_amoeba_dat

#ifdef MPI
!*******************************************************************************
!
! Subroutine:  bcast_mdin_amoeba_dat
!
! Description: <TBS>
!              
!*******************************************************************************

subroutine bcast_mdin_amoeba_dat

  use parallel_dat_mod

  implicit none

  call mpi_bcast(do_amoeba_valence, mdin_amoeba_int_cnt, mpi_integer, 0, &
                 mpi_comm_world, err_code_mpi)

  call mpi_bcast(compress, mdin_amoeba_dbl_cnt, mpi_double_precision, 0, &
                 mpi_comm_world, err_code_mpi)

  return

end subroutine bcast_mdin_amoeba_dat
#endif

!*******************************************************************************
!
! Subroutine:  validate_mdin_amoeba_dat
!
! Description: <TBS>
!              
!*******************************************************************************

subroutine validate_mdin_amoeba_dat

  use gbl_constants_mod
  use parallel_dat_mod
  use mdin_ctrl_dat_mod

  implicit none

! Local variables

  integer       :: inerr

! Check on bogus data and unsupported options:

  inerr = 0

! We allow this at present, and use 0 accelerations, period.
!
! if (ntx .lt. 4 .and.  beeman_integrator .ne. 0) then
!   write(mdout, '(a,a)') error_hdr, &
!     'Use of ntx < 4 with the Beeman integrator is not supported.'
!   inerr = 1
! end if 

  ! We now check for specific nmropt .ne. 0 usage in the nmr code, not
  ! allowing just about everything except &wt TEMP0.

  if (ibelly .ne. 0) then
    write(mdout, '(a,a)') error_hdr, &
      'Use of belly dynamics (ibelly != 0) with the'
    write(mdout, '(a,a)') extra_line_hdr, &
      'Amoeba forcefield is not yet supported.'
    inerr = 1
  end if

  if (beeman_integrator .ne. 0) then

    if (ntwe .ne. 0) then
      write(mdout, '(a,a)') error_hdr, &
        'Use of mden file output (ntwe != 0) with the'
      write(mdout, '(a,a)') extra_line_hdr, &
        'Beeman integrator is not supported.'
      inerr = 1
    end if

    if (iwrap .ne. 0) then
      write(mdout, '(a,a)') error_hdr, &
        'Use of coordinate wrapping (iwrap != 0) with the'
      write(mdout, '(a,a)') extra_line_hdr, &
        'Beeman integrator is not yet supported.'
      inerr = 1
    end if

    if (ioutfm .ne. 0) then
      write(mdout, '(a,a)') error_hdr, &
        'Use of binary trajectory (netCDF) files (ioutfm != 0) with the'
      write(mdout, '(a,a)') extra_line_hdr, &
        'Beeman integrator is not yet supported.'
      inerr = 1
    end if

    if (ntwprt .ne. 0) then
      write(mdout, '(a,a)') error_hdr, &
        'Use of the crd/vel archive limit flag (ntwprt != 0) with the'
      write(mdout, '(a,a)') extra_line_hdr, &
        'Beeman integrator is not yet supported.'
      inerr = 1
    end if

    if (nrespa .ne. 1) then
      write(mdout, '(a,a)') error_hdr, &
        'Use of respa (nrespa != 1) with the'
      write(mdout, '(a,a)') extra_line_hdr, &
        'Beeman integrator is not yet supported.'
      inerr = 1
    end if

    if (ntp .gt. 1) then
      write(mdout, '(a,a)') error_hdr, &
        'Use of nonisotropic pressure scaling with the '
      write(mdout, '(a,a)') extra_line_hdr, &
        'Beeman integrator is not supported.'
      write(mdout, '(a,a)') extra_line_hdr, &
        'Please use ntp < 2 with the Beeman integrator.'
      inerr = 1
    end if

    if (ntt .ne. 0 .and. ntt .ne. 1) then
      write(mdout, '(a,a)') error_hdr, &
        'Use of ntt > 1 (Andersen thermostat or Langevin Dynamics) with the'
      write(mdout, '(a,a)') extra_line_hdr, &
        'Beeman integrator is not yet supported.'
      inerr = 1
    end if

  end if ! beeman_integrator .ne. 0

! Field any errors and bag out.

  if (inerr .eq. 1) then
    write(mdout, '(/,a)') ' Input errors occurred. Terminating execution.'
    call mexit(mdout, 1)
  else
    write(mdout, '(a)') ' '
  end if

  return

end subroutine validate_mdin_amoeba_dat

#endif /* AMOEBA */
end module mdin_amoeba_dat_mod
