#==============================================================================
# AMBER Makefile configuration for compiler/architecture: ifort_ia32
# Generated via command: ./configure -lam -p4 -static ifort_ia32
#
# Configuration script written mainly by Joe Krahn, Scott Brozell, and
# Dave Case, with contributions from lots of people.
#==============================================================================

#------------------------------------------------------------------------------
# Main AMBER source root directory
#------------------------------------------------------------------------------
AMBER_SRC=/scr/arwen_2/seabra/amber10/src

#------------------------------------------------------------------------------
# AMBERBUILDFLAGS provides a hook into the build process for installers;
# for example, to build debug versions of the amber programs
# make -e AMBERBUILDFLAGS="-DDEBUG -g"
#------------------------------------------------------------------------------
AMBERBUILDFLAGS=

#------------------------------------------------------------------------------
# LOCALFLAGS is intended for program specific modifications to the
# Fortran build process and may be modified by the program's local makefile
#------------------------------------------------------------------------------
LOCALFLAGS=

#------------------------------------------------------------------------------
# Availability and method of delivery of math and optional libraries
#------------------------------------------------------------------------------
USE_BLASLIB=$(VENDOR_SUPPLIED)
USE_LAPACKLIB=$(VENDOR_SUPPLIED)
USE_LMODLIB=$(LMOD_UNAVAILABLE)

#------------------------------------------------------------------------------
# C compiler
#------------------------------------------------------------------------------
CC= gcc -m32
CPLUSPLUS=g++
CFLAGS= -D_FILE_OFFSET_BITS=64 -D_LARGEFILE_SOURCE -O2
CPPFLAGS= $(AMBERBUILDFLAGS)

#------------------------------------------------------------------------------
# Fortran preprocessing and compiler.
# FPPFLAGS holds the main Fortran options, such as whether MPI is used.
#------------------------------------------------------------------------------
FPPFLAGS= -I/share/local/include -P -DMKL -DMPI $(AMBERBUILDFLAGS)
FPP= cpp -traditional $(FPPFLAGS)
FC= ifort
FFLAGS=  -std95  -vec_report0 -mp1 -O0 $(LOCALFLAGS) $(AMBERBUILDFLAGS)
FOPTFLAGS=  -std95  -vec_report0 -mp1 -ip -O3 -axNP $(LOCALFLAGS) $(AMBERBUILDFLAGS)
FREEFORMAT_FLAG= -FR

#------------------------------------------------------------------------------
# Loader:
#------------------------------------------------------------------------------
LOAD= ifort -static $(LOCALFLAGS) $(AMBERBUILDFLAGS)
LOADCC= gcc -m32 -static $(LOCALFLAGS) $(AMBERBUILDFLAGS)
LOADLIB=  -lsvml /opt/intel/ict/2.0/cmkl/8.0.1/lib/32/libmkl_lapack.a /opt/intel/ict/2.0/cmkl/8.0.1/lib/32/libmkl_ia32.a -L/opt/intel/ict/2.0/cmkl/8.0.1/lib/32 -lguide -lpthread -L/share/local/lib -llammpio -llamf77mpi -lmpi -llam -lutil  -lpthread
LM= -lm
LOADPTRAJ= ifort -nofor_main -static $(LOCALFLAGS) $(AMBERBUILDFLAGS)
XHOME= /usr/X11R6
XLIBS= -L/usr/X11R6/lib

#------------------------------------------------------------------------------
#  Other stuff:
#------------------------------------------------------------------------------
.SUFFIXES:  .f90
EMPTY=
AR=ar rv $(EMPTY)
M4=m4
RANLIB=ranlib
SFX=
NETCDF=
NETCDFLIB=
MODULEDIR=-I
MAKEDEPEND=$(AMBER_SRC)/../bin/amber_makedepend
SLKO=skipDFTB

#  default rules for Fortran and C compilation:

.f.o:   $<
	$(FPP) $< > _$<
	$(FC) -c $(FFLAGS) -o $@ _$<

.c.o:
	$(CC) -c $(CFLAGS) $(CPPFLAGS) -o $@ $<

